/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed.cim;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.cim.CimProvider;
import com.ibm.hwmca.fw.util.ClassDescriptors;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.provider20.AssociatorProvider;

public abstract class AssociationCimProvider
extends CimProvider
implements AssociatorProvider {
    private ClassId providedClassId;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "AssocCimProv");
    private static final String TRACE_MASKT = "XCIMAP T";
    private static final String TRACE_MASKF = "XCIMAP F";
    private static final String TRACE_MASKD = "XCIMAP D";

    protected AssociationCimProvider(String providedClassName) {
        this.providedClassId = new ClassId(providedClassName);
        Trace.trace(TRACE_MASKT, "<> AssociationCimProvider()");
    }

    public ClassId getProvidedClassId() {
        return this.providedClassId;
    }

    public Vector enumInstances(CIMObjectPath path, boolean deep, CIMClass cimClass) throws CIMException {
        Trace.trace(TRACE_MASKT, "-> enumInstances(path=" + path + ",deep=" + deep + ",cimClass=" + (cimClass == null ? "null" : cimClass.getName()) + ")");
        Vector<CIMObjectPath> result = new Vector<CIMObjectPath>();
        try {
            Set inventory = mom.getInventoryObjectIds(this.getProvidedClassId());
            Iterator iterator = inventory.iterator();
            while (iterator.hasNext()) {
                ObjectId associationId = (ObjectId)iterator.next();
                CIMObjectPath associationPath = AssociationCimProvider.objectIdToPath(associationId);
                result.add(associationPath);
                Trace.trace(TRACE_MASKD, "Adding path " + associationPath);
            }
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 672, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred enumerating instances for " + path));
        }
        Trace.trace(TRACE_MASKT, "<- enumInstances(returns " + result.size() + " instances)");
        return result;
    }

    public Vector enumInstances(CIMObjectPath path, boolean deep, CIMClass cimClass, boolean localOnly) throws CIMException {
        Trace.trace(TRACE_MASKT, "-> enumInstances(path=" + path + ",deep=" + deep + ",cimClass=" + (cimClass == null ? "null" : cimClass.getName()) + ",localOnly=" + localOnly + ")");
        Vector<CIMInstance> result = new Vector<CIMInstance>();
        Vector paths = this.enumInstances(path, deep, cimClass);
        try {
            Iterator associationPaths = paths.iterator();
            while (associationPaths.hasNext()) {
                CIMObjectPath associationPath = (CIMObjectPath)associationPaths.next();
                CIMInstance association = this.buildInstance(associationPath, true, true);
                result.add(association);
                Trace.trace(TRACE_MASKD, "Adding association " + association);
            }
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 672, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred enumerating instances for " + path));
        }
        Trace.trace(TRACE_MASKT, "<- enumInstances(returns " + result.size() + " instances)");
        return result;
    }

    public CIMInstance getInstance(CIMObjectPath path, CIMClass cimClass, boolean localOnly) throws CIMException {
        CIMInstance result;
        Trace.trace(TRACE_MASKT, "-> getInstance(path=" + path + ",cimClass=" + cimClass.getName() + ",localOnly=" + localOnly + ")");
        try {
            result = cimClass.newInstance();
            Iterator keys = path.getKeys().iterator();
            while (keys.hasNext()) {
                CIMProperty key = (CIMProperty)keys.next();
                result.getProperty(key.getName()).setValue(key.getValue());
            }
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 673, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred getting instance " + path));
        }
        if (result != null) {
            Trace.trace(TRACE_MASKD, result.toMOF());
        }
        Trace.trace(TRACE_MASKT, "<- getInstance(returns " + (result == null ? "null" : result.getName()) + ")");
        return result;
    }

    public Vector associators(CIMObjectPath assocClass, CIMObjectPath path, String resultClassName, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyNames) throws CIMException {
        Trace.trace(TRACE_MASKF, "-> associators(assocClass=" + assocClass + ",path=" + path + ",resultClassName=" + resultClassName + ",role=" + role + ",resultRole=" + resultRole + ",includeQualifiers=" + includeQualifiers + ",includeClassOrigin=" + includeClassOrigin + ",propertyNames=" + propertyNames + ")");
        Vector<CIMInstance> result = new Vector<CIMInstance>();
        Vector names = this.associatorNames(assocClass, path, resultClassName, role, resultRole);
        try {
            Iterator paths = names.iterator();
            while (paths.hasNext()) {
                result.add(this.buildInstance((CIMObjectPath)paths.next(), includeQualifiers, includeClassOrigin));
            }
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 674, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred finding associators for " + path));
        }
        Trace.trace(TRACE_MASKF, "<- associators(return " + result.size() + " items)");
        return result;
    }

    public Vector associatorNames(CIMObjectPath assocClass, CIMObjectPath path, String resultClassName, String role, String resultRole) throws CIMException {
        Trace.trace(TRACE_MASKF, "-> associatorNames(assocClass=" + assocClass + ",path=" + path + ",resultClassName=" + resultClassName + ",role=" + role + ",resultRole=" + resultRole + ")");
        Vector<Object> result = new Vector<Object>();
        CIMClass targetClass = descriptors.findCimClass(path.getObjectName());
        if (this.isValidAssociationTarget(new ClassId(targetClass.getName()))) {
            Vector inventory = this.enumInstances(assocClass, true, null);
            try {
                Iterator paths = inventory.iterator();
                while (paths.hasNext()) {
                    CIMObjectPath associationPath = (CIMObjectPath)paths.next();
                    CIMProperty targetKey = null;
                    CIMProperty resultKey = null;
                    Iterator keys = associationPath.getKeys().iterator();
                    while (keys.hasNext()) {
                        CIMProperty key = (CIMProperty)keys.next();
                        if (!key.isReference()) continue;
                        if (path.equals(key.getValue().getValue())) {
                            targetKey = key;
                            continue;
                        }
                        resultKey = key;
                    }
                    if (!(targetKey != null & resultKey != null) || role != null && !role.equalsIgnoreCase(targetKey.getName()) || resultRole != null && !resultRole.equalsIgnoreCase(resultKey.getName())) continue;
                    Trace.trace(TRACE_MASKD, "adding " + resultKey.getValue().getValue());
                    result.add(resultKey.getValue().getValue());
                }
            }
            catch (Throwable thrown) {
                new FrameworkLog(logInfo, 675, thrown).log(LogAttributes.INFO_LOG);
                if (thrown instanceof CIMException) {
                    throw (CIMException)thrown;
                }
                throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred finding associator names for " + path));
            }
        }
        Trace.trace(TRACE_MASKF, "<- associatorNames(return " + result.size() + " names)");
        return result;
    }

    public Vector references(CIMObjectPath assocClass, CIMObjectPath path, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyNames) throws CIMException {
        Trace.trace(TRACE_MASKF, "-> references(assocClass=" + assocClass + ",path=" + path + ",role=" + role + ",includeQualifiers=" + includeQualifiers + ",includeClassOrigin=" + includeClassOrigin + ",propertNames=" + propertyNames + ")");
        Vector<CIMInstance> result = new Vector<CIMInstance>();
        Vector names = this.referenceNames(assocClass, path, role);
        try {
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                result.add(this.buildInstance((CIMObjectPath)iterator.next(), includeQualifiers, includeClassOrigin));
            }
        }
        catch (Throwable thrown) {
            new FrameworkLog(logInfo, 676, thrown).log(LogAttributes.INFO_LOG);
            if (thrown instanceof CIMException) {
                throw (CIMException)thrown;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred finding references for " + path));
        }
        Trace.trace(TRACE_MASKF, "<- references(return " + result.size() + " items)");
        return result;
    }

    public Vector referenceNames(CIMObjectPath assocClass, CIMObjectPath path, String role) throws CIMException {
        Trace.trace(TRACE_MASKF, "-> referenceNames(assocClass=" + assocClass + ",path=" + path + ",role=" + role + ")");
        Vector<CIMObjectPath> result = new Vector<CIMObjectPath>();
        CIMClass targetClass = descriptors.findCimClass(path.getObjectName());
        if (this.isValidAssociationTarget(new ClassId(targetClass.getName()))) {
            Vector inventory = this.enumInstances(assocClass, true, null);
            try {
                Iterator paths = inventory.iterator();
                while (paths.hasNext()) {
                    CIMObjectPath associationPath = (CIMObjectPath)paths.next();
                    CIMProperty targetKey = null;
                    Iterator keys = associationPath.getKeys().iterator();
                    while (keys.hasNext()) {
                        CIMProperty key = (CIMProperty)keys.next();
                        if (!path.equals(key.getValue().getValue())) continue;
                        targetKey = key;
                        break;
                    }
                    if (targetKey == null || role != null && !role.equalsIgnoreCase(targetKey.getName())) continue;
                    Trace.trace(TRACE_MASKD, "adding " + associationPath);
                    result.add(associationPath);
                }
            }
            catch (Throwable thrown) {
                new FrameworkLog(logInfo, 677, thrown).log(LogAttributes.INFO_LOG);
                if (thrown instanceof CIMException) {
                    throw (CIMException)thrown;
                }
                throw new CIMException("CIM_ERR_FAILED", (Object)("An error occurred finding reference names for " + path));
            }
        }
        Trace.trace(TRACE_MASKF, "<- referenceNames(return " + result.size() + " names)");
        return result;
    }

    protected CIMInstance buildInstance(CIMObjectPath path, boolean includeQualifiers, boolean includeClassOrigin) {
        Vector qualifiers;
        String cimClassName = path.getObjectName();
        CIMClass javaClass = null;
        CIMInstance result = new CIMInstance();
        result.setClassName(cimClassName);
        if (includeQualifiers && (qualifiers = (javaClass = descriptors.findCimClass(cimClassName)).getQualifiers()) != null) {
            result.setQualifiers(ClassDescriptors.filterQualifiers(qualifiers));
        }
        Vector<CIMProperty> properties = new Vector<CIMProperty>();
        Iterator iterator = path.getKeys().iterator();
        while (iterator.hasNext()) {
            Vector qualifiers2;
            CIMProperty javaProperty;
            CIMProperty property = (CIMProperty)iterator.next();
            if (includeClassOrigin) {
                property.setOriginClass(cimClassName);
            }
            if (includeQualifiers && (javaProperty = javaClass.getProperty(property.getName())) != null && (qualifiers2 = javaProperty.getQualifiers()) != null) {
                property.setQualifiers(ClassDescriptors.filterQualifiers(qualifiers2));
            }
            properties.add(property);
        }
        result.setProperties(properties);
        return result;
    }

    protected boolean isValidAssociationTarget(ClassId id) {
        return true;
    }
}

